package game;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;


/*
 * solidness---solid, passthru, or neither (maybe I could include the ability to be passthru in the four cardinal directions
injures---if the player touches it, will the player be injured?
movement speed---what is the movement, in pixels per tick, that this object can move at?
movement goal---where should the object be heading?  Should it be heading for the player?  Should it be heading for a pre-defined location?  Should it
                simply be heading in a particular direction?
movement restrictions---does gravity apply to the enemy?  Does the enemy have the ability to go through blocks?  Can the enemy move while the player is
                        facing it?
player bullet reactions---should the enemy take damage when hit by a bullet?  Should it ignore bullets?  Should it absorb bullets?
enemy bullet firing---should the enemy fire bullets?  Which direction?  Should it fire them at the player, or in a specified direction?
images for animation during this mode
rules for changing behavior---zero to many of them
healing---should I heal slowly in this mode?
 */

public class CustomNpcBehavior {
	
	
	
	private boolean isSolid;
	private boolean shouldInjure;
	private int maxMoveSpeedX;
	private int maxMoveSpeedY;
	//need movement goals
	
	private int xTargetThresholdForBehavior;
	private int yTargetThresholdForBehavior;
	
	private int movementGoalMode;
	
	private int movementParameterX;
	private int movementParameterY;
	private String movementParameterName;
	
	private boolean shouldAvoidMoveGoal;
	
	public static final int MOVE_GOAL_NONE = 0;
	public static final int MOVE_GOAL_PLAYER = 1;
	public static final int MOVE_GOAL_DIRECTION = 2;
	public static final int MOVE_GOAL_OTHER_NPC = 3;
	public static final int MOVE_GOAL_PREDEFINED_POINT = 4;
	
	private boolean doesGravityApply;
	private boolean canMoveThroughBlocks;
	
	private int playerBulletReceiveMode;
	private int enemyBulletReceiveMode;
	
	public static final int BULLET_RECEIVE_NONE = 0;
	public static final int BULLET_RECEIVE_BLOCK = 1;
	public static final int BULLER_RECEIVE_DAMAGE = 2;
	
	/*private int bulletFiringMode;
	
	private int bulletFireParameterX;
	private int bulletFireParameterY;
	private String bulletFireParameterString;
	
	public static final int BULLET_FIRE_NONE = 0;
	public static final int BULLET_FIRE_DIRECTION = 1;
	public static final int BULLET_FIRE_PLAYER = 2;*/
	
	//need to replace the above with a list of firing rules
	
	private CustomImageDataII images[];
	private int currentImageFrame;
	
	private CustomNpcBehaviorSwitchRule switchRules[] = null;
	
	private boolean drawOverPlayer;
	private boolean drawOverStaticBlocks;
	private boolean drawOverRogueBlocks;
	
	
	public CustomNpcBehavior(CustomImageDataII [] imageArray, 
							  boolean shouldDrawOverPlayer, 
							  boolean shouldDrawOverStaticBlocks, 
							  boolean shouldDrawOverRogueBlocks,
							  CustomNpcBehaviorSwitchRule [] theSwitchRules,
							  int thePlayerBulletReceiveRules,
							  int theEnemyBulletReceiveRules,
							  boolean gravityShouldApply,
							  boolean shouldMoveThroughBlocks,
							  boolean shouldBeTreatedAsSolidBlock,
							  boolean shouldInjurePlayerOnContact,
							  int maximumXSpeed,
							  int maximumYSpeed,
							  int desiredMovementGoalMode,
							  int desiredMovementXParm,
							  int desiredMovementYParm,
							  String desiredMovementStrParm) {
		
		images = imageArray;
		currentImageFrame = 0;
		
		drawOverPlayer = shouldDrawOverPlayer;
		drawOverStaticBlocks = shouldDrawOverStaticBlocks;
		drawOverRogueBlocks = shouldDrawOverRogueBlocks;
		
		switchRules = theSwitchRules;
		
		playerBulletReceiveMode = thePlayerBulletReceiveRules;
		enemyBulletReceiveMode = theEnemyBulletReceiveRules;
		
		doesGravityApply = gravityShouldApply;
		canMoveThroughBlocks = shouldMoveThroughBlocks;
		
		isSolid = shouldBeTreatedAsSolidBlock;
		shouldInjure = shouldInjurePlayerOnContact;
		maxMoveSpeedX = maximumXSpeed;
		maxMoveSpeedY = maximumYSpeed;
		
		

		movementGoalMode = desiredMovementGoalMode;
		movementParameterX = desiredMovementXParm;
		movementParameterY = desiredMovementYParm;
		movementParameterName = desiredMovementStrParm;
		
		
	}
	
	public CustomNpcBehavior update(CustomNpc npc, PlayerSprite player, StaticBlockManager blockManager, ArrayList<SolidBlockSprite> blocks) {  //definitely we'll need more parameters to figure out the player's position and that...
		
		int targetX = 0;
		int targetY = 0;
		int thisX = 0;
		int thisY = 0;
		
		
		switch(movementGoalMode) {
		case MOVE_GOAL_NONE:
		default:
			break;
		case MOVE_GOAL_PLAYER:
			
			targetX = player.getxPos();
			targetY = player.getyPos();
			
			thisX = npc.getxPos();
			thisY = npc.getyPos();
			
			if(thisX < targetX) {
				npc.setNextXPos( thisX + (shouldAvoidMoveGoal ? -1 : 1) * Math.min(targetX - thisX, maxMoveSpeedX) );
			} else {
				npc.setNextXPos( thisX - (shouldAvoidMoveGoal ? -1 : 1) * Math.min(thisX - targetX, maxMoveSpeedX) );
			}
			
			if(thisY < targetY) {
				npc.setNextYPos( thisY + (shouldAvoidMoveGoal ? -1 : 1) * Math.min(targetY - thisY, maxMoveSpeedY) );
			} else {
				npc.setNextYPos( thisY - (shouldAvoidMoveGoal ? -1 : 1) * Math.min(thisY - targetY, maxMoveSpeedY) );
			}
			
			break;
			
		}
		
//		System.out.println("<><>DELME before the blocks, current pos is: " + npc.getCurrentPosCollisionRect().getMaxX() + ", " + npc.getCurrentPosCollisionRect().getMinY() + "  --- next is: " + npc.getNextPosCollisionRect().getMaxX() + ", " + npc.getNextPosCollisionRect().getMinY());
//		System.out.println("<><>DELME before the blocks, current pos is: " + npc.getxPos() + ", " + npc.getyPos() + "  --- next is: " + npc.getNextXPos() + ", " + npc.getNextYPos());
		
		//going to need to ALSO go through bullet and block things, too...
		if(!canMoveThroughBlocks) {
			
			boolean isMovingDown = npc.getNextYPos() > npc.getyPos();
			boolean isMovingUp = npc.getNextYPos() < npc.getyPos();
			
			BlockInterface floorBlock = null;
			if(isMovingDown) {
				floorBlock = blockManager.findFloorBlock(npc);
				floorBlock = npc.findAlternateFloorBlockFromRogueBlocksII(blocks, floorBlock, npc.getCurrentPosCollisionRect(), npc.getNextPosCollisionRect());
			} else {
				floorBlock = blockManager.findFloorBlockUseNextPos(npc);
				floorBlock = npc.findAlternateFloorBlockFromRogueBlocksII(blocks, floorBlock, npc.getCurrentPosCollisionRect(), npc.getNextPosCollisionRect());
			}
			
			int npcNextXPos = npc.getNextXPos();
			npc.setNextXPos(npc.getxPos());
			
			BlockInterface ceilingBlock = null;
			if(isMovingUp) {
				ceilingBlock = blockManager.findCeilingBlock(npc);
				ceilingBlock = npc.findAlternateCeilingBlockFromRogueBlocks(blocks, ceilingBlock, npc.getNextPosCollisionRect());
			} else {
				ceilingBlock = blockManager.findCeilingBlockUseNextPos(npc);
				ceilingBlock = npc.findAlternateCeilingBlockFromRogueBlocks(blocks, ceilingBlock, npc.getNextPosCollisionRect());
			}
			
			npc.setNextXPos(npcNextXPos);
			
			boolean movedBecauseOfCeiling = false;
			boolean movedBecauseOfFloor = false;
			
			if(floorBlock != null) {
				if(ceilingBlock != null 
						&& floorBlock.getCollisionRectMinY() - ceilingBlock.getCollisionRectMaxY() < (npc.getCollisionHeight() + 1) 
						&& !floorBlock.isPassThrough()) {
					//squish!
				}
				
				
				int floorBlockCollisionRectMinY = floorBlock.getCollisionRectMinY();
				int playerNextMaxY = npc.getNextPosCollisionRect().getMaxY();
				if(floorBlockCollisionRectMinY -1 < playerNextMaxY) {
					npc.setNextYPos(npc.getNextYPos()- (playerNextMaxY - floorBlockCollisionRectMinY + 1)) ;
					movedBecauseOfFloor = true;
				}
			}
			
			if(ceilingBlock != null) {
				
				int ceilingBlockCollisionRectMaxY = ceilingBlock.getCollisionRectMaxY();
				int playerNextMinY = npc.getNextPosCollisionRect().getMinY();
				if(ceilingBlockCollisionRectMaxY + 1 > playerNextMinY) {
					npc.setNextYPos(npc.getNextYPos() + (ceilingBlockCollisionRectMaxY + 1 - playerNextMinY));
					movedBecauseOfCeiling = true;
				}
				
			}
			
			if(movedBecauseOfCeiling && movedBecauseOfFloor) {
				//should put it smack dab between the two
				
				npc.setNextYPos((ceilingBlock.getCollisionRectMaxY() + floorBlock.getCollisionRectMinY()) / 2);
			}
			
			
			
			//one assumes we do the same for the horizontal stuff.
			
			boolean movedBecauseOfLeftWall = false;
			boolean movedBecauseOfRightWall = false;
			
			boolean isMovingLeft = npc.getNextXPos() < npc.getxPos();
			boolean isMovingRight = npc.getNextXPos() > npc.getxPos();
			
			int leftWall;
			if(isMovingLeft) {
				
				leftWall = blockManager.getLeftWallUseCurrentPos(npc, npc.getCurrentPosCollisionRect());
				for(SolidBlockSprite s : blocks) {
					
					if(s.getCollisionRectMaxY() < npc.getCurrentPosCollisionRect().getMinY() 
							|| s.getCollisionRectMinY() > npc.getCurrentPosCollisionRect().getMaxY()) {
						continue;
					}
					
					if(s.getxPos() < npc.getxPos()) {
						//candidate!
						if(s.getCollisionRectMaxX() > leftWall)
							leftWall = s.getCollisionRectMaxX();
					}
					
				}
				
			} else {
				
				leftWall = blockManager.getLeftWallUseNextPos(npc, npc.getNextPosCollisionRect());
				for(SolidBlockSprite s : blocks) {
					
					if(s.getCollisionRectMaxY() < npc.getNextPosCollisionRect().getMinY() 
							|| s.getCollisionRectMinY() > npc.getNextPosCollisionRect().getMaxY()) {
						continue;
					}
					
					if(s.getxPos() < npc.getNextXPos()) {
						//candidate!
						if(s.getCollisionRectMaxX() > leftWall)
							leftWall = s.getCollisionRectMaxX();
					}
					
				}
				
				
			}
			
			
			int rightWall;
			if(isMovingRight) {
				
				rightWall = blockManager.getRightWallUseCurrentPos(npc, npc.getCurrentPosCollisionRect());
				for(SolidBlockSprite s : blocks) {
					
					if(s.getCollisionRectMaxY() < npc.getCurrentPosCollisionRect().getMinY() 
							|| s.getCollisionRectMinY() > npc.getCurrentPosCollisionRect().getMaxY()) {
						continue;
					}
					
					if(s.getxPos() > npc.getxPos()) {
						//candidate!
						if(s.getCollisionRectMinX() < rightWall)
							rightWall = s.getCollisionRectMinX();
					}
					
				}
				
			} else {
				
				rightWall = blockManager.getRightWallUseNextPos(npc, npc.getNextPosCollisionRect());
				for(SolidBlockSprite s : blocks) {
					
					if(s.getCollisionRectMaxY() < npc.getNextPosCollisionRect().getMinY() 
							|| s.getCollisionRectMinY() > npc.getNextPosCollisionRect().getMaxY()) {
						continue;
					}
					
					if(s.getxPos() > npc.getNextXPos()) {
						//candidate!
						if(s.getCollisionRectMinX() < rightWall)
							rightWall = s.getCollisionRectMinX();
					}
					
				}
				
				
			}
			
			
			
			//squishing, then moving the NPC
			if(rightWall - leftWall < (npc.getCollisionWidth() + 1)) {
				//squish!
			}
			
			
			int playerNextMaxX = npc.getNextPosCollisionRect().getMaxX();
			if(rightWall -1 < playerNextMaxX) {
				npc.setNextXPos(npc.getNextXPos()- (playerNextMaxX - rightWall + 1)) ;
				movedBecauseOfRightWall = true;
			}
			
			int playerNextMinX = npc.getNextPosCollisionRect().getMinX();
			if(leftWall + 1 > playerNextMinX) {
				npc.setNextXPos(npc.getNextXPos() + (leftWall + 1 - playerNextMinX));
				movedBecauseOfLeftWall = true;
			}
			
			
			if(movedBecauseOfLeftWall && movedBecauseOfRightWall) {
				//should put it smack dab between the two
				
				npc.setNextXPos((leftWall + rightWall) / 2);
			}
			
//			System.out.println("<><>DELME ceiling: " + (ceilingBlock == null ? "null" : ceilingBlock.getCollisionRectMaxY()) + ", floor: " + (floorBlock == null ? "null" : floorBlock.getCollisionRectMinY()) + ", leftwall: " + (leftWall == Integer.MIN_VALUE ? "null" : leftWall) + ", rightWall: " + (rightWall == Integer.MIN_VALUE ? "null" : rightWall) + ";    moved b/c of ceiling? " + movedBecauseOfCeiling + ", floor?" + movedBecauseOfFloor + ", left wall? " + movedBecauseOfLeftWall + ", right wall? " + movedBecauseOfRightWall);
			
			
		}
		
		
//		System.out.println("<><>DELME  after the blocks, current pos is: " + npc.getCurrentPosCollisionRect().getMaxX() + ", " + npc.getCurrentPosCollisionRect().getMinY() + "  --- next is: " + npc.getNextPosCollisionRect().getMaxX() + ", " + npc.getNextPosCollisionRect().getMinY());
//		System.out.println("<><>DELME  after the blocks, current pos is: " + npc.getxPos() + ", " + npc.getyPos() + "  --- next is: " + npc.getNextXPos() + ", " + npc.getNextYPos());
//		System.out.println("<><>DELME ");
		
		
		
		//and now, set the next stuff...
		
		npc.setxPos(npc.getNextXPos());
		npc.setyPos(npc.getNextYPos());
		
		return this;
		
	}
	
	public void draw(Graphics g, int x, int y) {
		if(images == null || images.length == 0)
			return;
		
		if(currentImageFrame >= images.length)
			currentImageFrame = 0;
		
		images[currentImageFrame].drawObject(g, x, y);
		
		currentImageFrame++;
	}
	
	public static CustomNpcBehavior getDummyEvilSmiley(PonyPanel caller) {
		
		CustomImageDataII images[] = new CustomImageDataII[12];
		for(int i = 0; i < 12; i++) {
			images[i] = new CustomImageDataII("/images/evilSmilie" + i + ".GIF", Color.green, caller);
		}
		
		
		CustomNpcBehavior returnValue = new CustomNpcBehavior(images, true, true, true,
															  null, CustomNpcBehavior.BULLET_RECEIVE_NONE, CustomNpcBehavior.BULLET_RECEIVE_NONE, 
															  false, false, false, false,
															  2, 2, MOVE_GOAL_PLAYER, 0,0, null);
		
		return returnValue;
		
	}
	
	
	
	public boolean shouldDrawOverPlayer() {
		return drawOverPlayer;
	}
	
	public boolean shouldDrawOverStaticBlocks() {
		return drawOverStaticBlocks;
	}
	
	public boolean shouldDrawOverRogueBlocks() {
		return drawOverRogueBlocks;
	}
	
}
